ServerEvents.recipes(event => {
    // Red alloy through create
    event.recipes.create.mixing(
        'gtceu:red_alloy_dust',
        [
            Item.of('minecraft:redstone', 4),
            '#forge:dusts/copper'
        ]
    )

    // Wood pulp through create
    event.recipes.create.pressing('gtceu:wood_dust', '#minecraft:logs');
    event.recipes.create.pressing('gtceu:wood_dust', '#minecraft:planks');
    event.recipes.create.pressing('gtceu:wood_dust', '#minecraft:wooden_stairs');
    event.recipes.create.pressing('gtceu:wood_dust', '#minecraft:wooden_slabs');

    // Wood plank through create
    event.recipes.create.pressing('gtceu:wood_plate', 'gtceu:wood_dust');

    // Rubber pulp through create
    event.recipes.create.crushing(
        Item.of('gtceu:raw_rubber_dust', 2),
        'gtceu:rubber_log'
    )
    event.recipes.create.milling(
        Item.of('gtceu:raw_rubber_dust', 1),
        'gtceu:rubber_log'
    )

    // Rubber ingot through create
    event.recipes.create.mixing(
        'gtceu:rubber_ingot',
        [
            Item.of('#forge:dusts/raw_rubber', 4),
            '#forge:dusts/sulfur'
        ]
    ).heated()

    // Basic electronic circuit to skip steam age
    event.remove({ output: 'gtceu:basic_electronic_circuit', input: 'gtceu:vacuum_tube' })
    event.shaped(
        'gtceu:basic_electronic_circuit',
        [
            'CSC',
            'ERE',
            'WWW'
        ],
        {
            C: 'create_new_age:copper_circuit',
            S: '#forge:plates/steel',
            E: 'create:electron_tube',
            R: 'gtceu:resin_printed_circuit_board',
            W: 'gtceu:red_alloy_single_cable',
        }
    )

    // Conveyors with create belts
    event.shaped(
        'gtceu:lv_conveyor_module',
        [
            'BBB',
            'MWM',
            'BBB'
        ],
        {
            B: 'create:belt_connector',
            M: 'gtceu:lv_electric_motor',
            W: 'gtceu:tin_single_cable',
        }
    )
    event.shaped(
        'gtceu:mv_conveyor_module',
        [
            'BBB',
            'MWM',
            'BBB'
        ],
        {
            B: 'create:belt_connector',
            M: 'gtceu:mv_electric_motor',
            W: 'gtceu:copper_single_cable',
        }
    )
    event.shaped(
        'gtceu:hv_conveyor_module',
        [
            'BBB',
            'MWM',
            'BBB'
        ],
        {
            B: 'create:belt_connector',
            M: 'gtceu:hv_electric_motor',
            W: 'gtceu:gold_single_cable',
        }
    )
    event.shaped(
        'gtceu:ev_conveyor_module',
        [
            'BBB',
            'MWM',
            'BBB'
        ],
        {
            B: 'create:belt_connector',
            M: 'gtceu:ev_electric_motor',
            W: 'gtceu:aluminium_single_cable',
        }
    )
    event.shaped(
        'gtceu:iv_conveyor_module',
        [
            'BBB',
            'MWM',
            'BBB'
        ],
        {
            B: 'create:belt_connector',
            M: 'gtceu:iv_electric_motor',
            W: 'gtceu:tungsten_single_cable',
        }
    )
})