ServerEvents.recipes(event => {
    // Replace default energy acceptor with harder one
    event.remove({ output: 'ae2:energy_acceptor', input: 'minecraft:copper_ingot' })
    event.recipes.create.mechanical_crafting('ae2:energy_acceptor', [
        ' SVS ',
        'STFTS',
        'VFEFV',
        'STFTS',
        ' SVS '
    ], {
        S: "ae2:smooth_sky_stone_block",
        V: "enderio:vibrant_alloy_ingot",
        T: "create:railway_casing",
        F: "ae2:fluix_crystal",
        E: "ae2:engineering_processor"
    })

    // Be able to farm nether stars
    event.recipes.create.mixing(
        'minecraft:nether_star',
        [
            'enderio:ender_crystal',
            Item.of('ad_astra:ostrum_ingot', 4),
            Item.of('minecraft:wither_skeleton_skull', 3),
            Fluid.of('kubejs:thick_fluid', 250),
        ]
    ).superheated()

    // Endgame motor
    event.recipes.create.mechanical_crafting('create:creative_motor', [
        'F H F',
        'FBBBF',
        'FSCSF',
        'FSKSF',
        'FSUSF',
        'FSRSF',
        'FBBBF',
        'F   F'
    ], {
        F: 'gtceu:hssg_frame',
        H: 'create:shaft',
        B: 'ad_astra:glacio_stone_bricks',
        S: 'thermalendergy:stellarium_ingot',
        C: '#gtceu:circuits/luv',
        K: 'ae2:cell_component_256k',
        U: 'estrogen:uwu',
        R: 'ad_astra:tier_4_rocket',
    })

    event.recipes.create.sequenced_assembly(
        [
            Item.of('create:creative_blaze_cake').withChance(130.0)
        ],
        'create:blaze_cake',
        [
            event.recipes.createFilling('create:blaze_cake', ['create:blaze_cake', Fluid.of('kubejs:thick_fluid', 1000)]),
            event.recipes.createPressing('create:blaze_cake', 'create:blaze_cake'),
            event.recipes.createDeploying('create:blaze_cake', ['create:blaze_cake', 'thermalendergy:stellarium_dust']),
            event.recipes.createPressing('create:blaze_cake', 'create:blaze_cake'),
        ]
    ).transitionalItem('create:blaze_cake').loops(5);
})