GTCEuStartupEvents.registry('gtceu:machine', event => {
    event.create('basic_alternator', 'multiblock')
        .rotationState(RotationState.NON_Y_AXIS)
        .recipeType('basic_alternator')
        .appearanceBlock(GTBlocks.CASING_STEEL_SOLID)
        .generator(true)
        .pattern(definition => FactoryBlockPattern.start()
            .aisle("CMC", "CMC", "#M#")
            .aisle("CMC", "KWC", "CMC")
            .aisle("CMC", "CMA", "#M#")
            .where('A', Predicates.controller(Predicates.blocks(definition.get())))
            .where('W', Predicates.blocks('tfmg:copper_coil'))
            .where("C", Predicates.blocks(GTBlocks.CASING_STEEL_SOLID.get()).or(Predicates.autoAbilities(definition.getRecipeTypes())))
            .where('#', Predicates.any())
            .where('K', Predicates.abilities(PartAbility.INPUT_KINETIC).setExactLimit(1))
            .where('M', Predicates.blocks('create_new_age:layered_magnet'))
            .build()
        )
        .workableCasingRenderer(
            "gtceu:block/casings/solid/machine_casing_solid_steel",
            "gtceu:block/multiblock/implosion_compressor", false
        )
})